/*
 * Unix specific debug commands
 */
#define DB_MAX_SIZE	1024

#define DBR_GETPSCMDS	(DBR_OS_GETSTART + 0)	/* Generate the master menus */
#define DBR_DOPSCMD	(DBR_OS_GETSTART + 1)	/* Remote ps execution */
#define DBR_GETHANGID	(DBR_OS_GETSTART + 2)	/* Get new pid after a hang */
#define DBR_GETCONFIG	(DBR_OS_GETSTART + 3)	/* Configuration parameters */
#define DBR_OPEN	(DBR_OS_GETSTART + 4)	/* Open process for tracing */
#define DBR_CLOSE	(DBR_OS_GETSTART + 5)	/* Close process for tracing */
#define DBR_GETSIGNAME	(DBR_OS_GETSTART + 6)	/* Get signal name */
#define DBR_CSIG	(DBR_OS_GETSTART + 7)	/* Clear current signal */
#define DBR_SSIG	(DBR_OS_GETSTART + 8)	/* Send signal */
#define DBR_SMASK	(DBR_OS_GETSTART + 9)	/* Set signal tracking mask */
#define DBR_HANGEXEC	(DBR_OS_GETSTART + 10)	/* stop on exec */
#define DBR_GETOSNAME	(DBR_OS_GETSTART + 11)	/* operating system name */
#define DBR_GETPROCTIME	(DBR_OS_GETSTART + 12)	/* get proc sys + usr time */
#define DBR_GETWD	(DBR_OS_GETSTART + 13)	/* get working directory */
#define DBR_GETDIRS	(DBR_OS_GETSTART + 14)	/* get list of directories */
#define DBR_GETCOREID	(DBR_OS_GETSTART + 15)	/* Fake pid for a core dump */
#define DBR_ATSYSCALL	(DBR_OS_GETSTART + 16)	/* at a system call */
#define DBR_GETPSFIELD	(DBR_OS_GETSTART + 17)	/* ps field with arg[0] */
#define DBR_WAITSTOP	(DBR_OS_GETSTART + 18)	/* Wait for process to stop */

#define DBR_HANG	(DBR_OS_PUTSTART + 0)	/* Start a new process */
#define DBR_CD		(DBR_OS_PUTSTART + 1)	/* Change directory */
#define DBR_COREOPEN	(DBR_OS_PUTSTART + 2)	/* Open a core dump */

/* DBR_GETCONFIG */
struct Unixconfig {
	long regaddr;
	long scratchaddr;
	long nsig;
	long exechang;
	long initsigmask;
};
